/*
kap2_mkm.ox
Et program for Ox som illustrer frste delen av kapittel 2 i Videregende emner i konometri.
Gunnar Brdsen og Ragnar Nymoen, juli 2013.
*/

/*Frst henter vi inn ndvendige bibliotek:
"oxstd" er grunnbiblioteket med alle de viktigeste funksjonene.
"database" er biblioteket med kommandoer som gjr oss istand til  lage
ulike databaser.
"oxdraw" inneholder kommandoene som gjr at vi kan lage GiveWin-figurer.
*/

#include <oxstd.h>
#include <database.h>
#include <oxdraw.h>
#pragma link("database.oxo")

// Her begynner koden

main()
{

/*
Frst m vi erklre hvilke navn som er variable. Det vil si at vi
vanligvis bygger opp denne variabellisten etterhvert som vi skriver programmet.
*/

decl y, i, I, X,n, k, etahat, betahat, Vb, seb, s2, s, RSS, TSS, R2;


//Vi begynner med  lage matrisene til variablene i eksempelet

	y = <8; 15; -11; 33; -1>;
// antal observasjoner,
	n = rows(y);
// konstantleddet,
	i = ones(n,1);
// og forklaringsvariablene,
	X = 1~<2, 0; -2, -2; -3, 1; 4, -3; -4, -1>;
// S kontrollerer vi at det stemmer:
	print("y", y, "X=", X);																						 

//Vi lagrer ogs dataene til senere bruk:
	decl dbase = new Database();
	dbase.Create(1,1,1,n,1);
	dbase.Append(y~X, {"y", "x1", "x2", "x3"});
	dbase.SaveIn7("kap2_mkm.in7");
	delete dbase;
	delete y, X; 
//************************************************************
/*
Vanligvis vil data eksistere :-), s derfor viser vi ogs
hvordan vi leser de inn fra en database:
*/
	
	decl data = new Database(), x1, x2, x3;
	data.Load("kap2_mkm.in7");
	data.Info();
	y = data.GetVar("y");
	x1 = data.GetVar("x1");
	x2 = data.GetVar("x2");
	x3 = data.GetVar("x3");
	X = x1~x2~x3;

//	
//// Vi br ogs alltid se figurer av dataseriene.
//// Vi lager derfor figurer som blir viste hvis vi bruker Oxmetrics:
//	DrawT(0, y', 1, 1, 1);					  
//	DrawTMatrix(1, X', {"x1", "x2", "x3"}, 1, 1, 1); 	  
//
//	ShowDrawWindow();

// N gr vi s videre med  finne estimatene for beta
	betahat = (X'X)^-1*X'y;
// og estimatene for restleddet eta
	etahat = y-X*betahat;
// S estimerer vi variansen til restleddet:
	k = columns(X);
	s2 = etahat'etahat/(n-k);
	print(s2);
// Den inverse av momentmatrisen er
	print((X'X)^-1);
// Dermed finner vi kovariansmatrisen til betahat
	Vb = s2*(X'X)^-1;
// og standardavvikene til betahat
	seb = sqrt(diagonal(Vb));

// N er det bare  finne summer av kvadrerte avvik og R^2
	RSS = etahat'etahat;
	//Vi trenger identitetsmatrisa:
	I = unit(n);
	TSS = y'(I-(i*i'/n))*y;
	R2 = 1-RSS/TSS;

//Til slutt skriver vi ut resultatene
	print("betahat", betahat', "s.e.(betahat)", seb,"s.e. of regression:", sqrt(s2), "RSS:", RSS, "R^2:", R2);

//Kontroller resultatene i PcGive.
}
