/*
kap2_mkm_med_restr.ox
Et program for Ox som illustrer hypotesetesting i kapittel 2 i Videregende emner i konometri.
Gunnar Brdsen og Ragnar Nymoen, juli 2013.
*/

/*Frst henter vi inn ndvendige bibliotek:
"oxstd" er grunnbiblioteket med alle de viktigeste funksjonene.
"database" er biblioteket med kommandoer som gjr oss istand til  lage
ulike databaser.
"oxdraw" inneholder kommandoene som gjr at vi kan lage GiveWin-figurer.
*/

#include <oxstd.h>
#include <database.h>
#include <oxdraw.h>
#pragma link("database.oxo")
#pragma array_base(1)	//indeksering av matriser starter p 1

// Her begynner koden

main()
{

/*
Frst m vi erklre hvilke navn som er variable. Det vil si at vi
vanligvis bygger opp denne variabellisten etterhvert som vi skriver programmet.
*/

decl y, X, n, k, etahat, betahat, Vb, seb, s2, s, RSS, I, i, TSS, R2;

/*
Leser inn datasettet laget med kap2_mkm.ox:
*/
	
	decl data = new Database(), x1, x2, x3;
	data.Load("kap2_mkm.in7");
	data.Info();
	y = data.GetVar("y");
	x1 = data.GetVar("x1");
	x2 = data.GetVar("x2");
	x3 = data.GetVar("x3");
	X = x1~x2~x3;
// S kontrollerer vi at det stemmer:
	print("y", y, "X=", X);																						 

/*
// Vi br ogs alltid se figurer av dataseriene.
// Vi lager derfor figurer som blir viste hvis vi bruker Oxmetrics:
	DrawT(0, y', 1, 1, 1);					  
	DrawTMatrix(1, X', {"x1", "x2", "x3"}, 1, 1, 1); 	  

	ShowDrawWindow();
*/
// N gr vi s videre med  finne estimatene for beta
	betahat = (X'X)^-1*X'y;

// og estimatene for restleddet eta
	etahat = y-X*betahat;

// S estimerer vi variansen til restleddet:
	n = rows(y);
	k = columns(X);
	s2 = etahat'etahat/(n-k);

// Dermed finner vi kovariansmatrisen til betahat
	Vb = s2*(X'X)^-1;

// og standardavvikene til betahat
	seb = sqrt(diagonal(Vb));

// N er det bare  finne summer av kvadrerte avvik og R^2
	RSS = etahat'etahat;
	//Vi trenger identitetsmatrisen:
	I = unit(n);
	i = ones(n);
	TSS = y'(I-(i*i'/n))*y;
	R2 = 1-RSS/TSS;

//Til slutt skriver vi ut resultatene
	print("betahat", betahat', "sf(betahat)", seb,"sigmahat", sqrt(s2), "RSS:", RSS, "R^2:", R2);


println("/*************************************/ ") ;
println("Med restriksjonene y0 = y - X[][2:] *<2;-7>");

//b2=2 og b3=-7:

decl R, r, Pr,etahat0, k0, betahat0, Kov0, seb0, s20, s0, RSS0, TSS0, R20;
	//Linere restriksjoner
	R = <0, 1, 0;
	0, 0, 1>	;
	r = <2; -7>;
	//parametre som skal estimeres, dvs. uten restriksjoner.
	k0 = rows(betahat)-rows(r);
	//betahatt med restriksjoner er gitt ved flgende formel
	betahat0 = betahat+invert(X'X)*R'*invert(R*invert(X'X)*R')*(r-R*betahat);
	// og estimatene for restleddet eta
	etahat0 = y-X*betahat0;
	// S estimerer vi variansen til restleddet:
	s20 = etahat0'etahat0/(n-k0);
	// Dermed finner vi kovariansmatrisen til betahat
	Kov0 = s20*(unit(k)-invert(X'X)*R'invert(R*invert(X'X)*R')*R)*invert(X'X);
	// og standardavvikene til betahat
	seb0 = sqrt(diagonal(Kov0));
	// N er det bare  finne summer av kvadrerte avvik og R^2
	RSS0 = etahat0'etahat0;
	//Vi trenger identitetsmatrisen:
	I = unit(n);
	TSS0 = y'(I-(i*i'/n))*y;
	R20 = 1-RSS0/TSS0;

//Til slutt skriver vi ut resultatene
println("betahat0", betahat0', "sf(betahat0)", seb0,"sigmahat0", sqrt(s20), "RSS0:", RSS0, "R^2:", R20);


println("/*************************************/ ");
println("Utfoerer F-testen med 2 restriksjoner");


decl F, Fdf1, Fdf2;
Fdf1 = 2;
Fdf2 = n-k;
F =  (Fdf2/Fdf1)*(RSS0-RSS)/RSS;

print("F-testen for beta2=2 og beta3=-7: F(",Fdf1,", ",Fdf2,") = ", F, "p-verdi: ", 1-probf(F, Fdf1,Fdf2)) ;

}
