/*
Ml1.ox
Et program for Ox som illustrer frste delen av kapittel 4 i Videregende emner i konometri.
Gunnar Brdsen og Ragnar Nymoen, juli 2013.
*/

/*Frst henter vi inn ndvendige bibliotek:
"oxstd" er grunnbiblioteket med alle de viktigeste funksjonene.
"oxdraw" inneholder kommandoene som gjr at vi kan lage GiveWin-figurer.
"oxfloat" definerer konstantene Pi og Pi^2.
"maximize" er en pakke med rutiner for maksimering av funksjoner.
"database" er biblioteket med kommandoer som gjr oss istand til  lage
ulike databaser.
"array_base(1)" setter indekseringen av matriser til  begynne med 1.

*/

#include <oxstd.h>
#include <database.h>
#include <oxdraw.h>
#include <oxfloat.h>  // defines M_PI, M_2PI
#import <maximize>
#pragma link("database.oxo")
#pragma array_base(1)

/*
Vi skal lage likelihoodfunksjoner, som vi s skal hente ved kommandoer. I funksjonene benyttes "y" og "X".
Derfor m vi definere dem som globale variable.
*/

decl y, X;


// loglikelihoodfunksjonen 
floglik(const theta, const adFunc, const avScore,const amHess)
{
    decl k, b, s2, dsum;
	 k = rows(theta)-1;
	 b = theta[:k];           /**     estimerte regresjonskoeffisienter              **/
     s2 = theta[k+1];           /**     Varians          **/

    dsum = sumsqrc(y - X*b)/rows(y) ;   //sums of squares deles med n p grunn av maksimeringsalgoritmen -- se "Introduction to Ox", s. 45. 
    adFunc[1] = -0.5 * (log(M_2PI * s2) + dsum / s2);

return 1;             // 1 indicates success
}


// Her begynner koden

main()
{

/*
Frst m vi erklre hvilke navn som er variable. Det vil si at vi
vanligvis bygger opp denne variabellisten etterhvert som vi skriver programmet.
*/

decl n, k, theta, Kov, dfunc;

/*
Vanligvis vil data eksistere :-), s derfor viser vi ogs
hvordan vi leser de inn fra en database:
*/
	
	decl data = new Database(), x1, x2, x3;
	data.Load("kap2_mkm.in7");
	data.Info();
	y = data.GetVar("y");
	x1 = data.GetVar("x1");
	x2 = data.GetVar("x2");
	x3 = data.GetVar("x3");
	X = x1~x2~x3;
// S kontrollerer vi at det stemmer:
	print("y", y, "X=", X);																						 

n = rows(y);
k = columns(X);

/*
// Vi br ogs alltid se figurer av dataseriene.
// Vi lager derfor figurer som blir viste hvis vi bruker Oxmetrics:
	DrawT(0, y', 1, 1, 1);					  
	DrawTMatrix(1, X', {"x1", "x2", "x3"}, 1, 1, 1); 	  

	ShowDrawWindow();
*/
/*******************************************************************/

//Maksimerer likelihoodfunksjonen
theta = <1;1;1;1>;
floglik(theta, &dfunc, 0, 0);

println("Opprinnelig loglikelihoodverdi er ", rows(y)*dfunc,
"ved verdiene: ", theta');

 MaxControl(-1,100);
 MaxBFGS(floglik, &theta, &dfunc, 0, TRUE);

println("Den maksimerte loglikelihoodverdien er ", rows(y)*dfunc,
"betahat: ", theta[:k]');
//beregner forventningsrett kovariansmatrise
Kov = (n/(n-k))*theta[k+1]*invert(X'X);
println("sfbetahat:  ", sqrt(diagonal(Kov)));
println("Sigmahat: ", sqrt((n/(n-k))*theta[k+1]));

}	