/*
kap4_mlaltder.ox
Et program for Ox som illustrer hypotesetesting via reparametriseringer i kapittel 4 i Videregende emner i konometri.
Gunnar Brdsen og Ragnar Nymoen, juli 2013.
*/

/*Frst henter vi inn ndvendige bibliotek:
"oxstd" er grunnbiblioteket med alle de viktigeste funksjonene.
"oxdraw" inneholder kommandoene som gjr at vi kan lage GiveWin-figurer.
"oxfloat" definerer konstantene Pi og Pi^2.
"maximize" er en pakke med rutiner for maksimering av funksjoner.
"database" er biblioteket med kommandoer som gjr oss istand til  lage
ulike databaser.
"array_base(1)" setter indekseringen av matriser til  begynne med 1.

*/

#include <oxstd.h>
#include <database.h>
#include <oxdraw.h>
#include <oxfloat.h>  // defines M_PI, M_2PI
#import <maximize>
#pragma link("database.oxo")
#pragma array_base(1)

/*
Vi skal lage likelihoodfunksjoner, som vi s skal hente ved kommandoer. I funksjonene benyttes "y" og "X".
Derfor m vi definere dem som globale variable.
*/

decl y, X, R, r;


// likelihood uten restriksjoner 
floglik(const theta, const adFunc, const avScore,const amHess)
{
    decl k, b, s2, dsum;
	 k = rows(theta)-1;
	 b = theta[:k];           /**     estimerte regresjonskoeffisienter              **/
     s2 = theta[k+1];           /**     Varians          **/

    dsum = sumsqrc(y - X*b)/rows(y) ;   //sums of squares deles med n p grunn av maksimeringsalgoritmen -- se "Introduction to Ox", s. 45. 
    adFunc[1] = -0.5 * (log(M_2PI * s2) + dsum / s2);

return 1;             // 1 indicates success
}

// likelihood med restriksjoner 
floglik0(const theta, const adFunc, const avScore,const amHess)
{
    decl k, b0, s2, dsum;
	k = rows(theta)-1;
	b0 = theta[:k]+invert(X'X)*R'*invert(R*invert(X'X)*R')*(r-R*theta[:k]);           /**     estimerte regresjonskoeffisienter              **/
     //b0 = <1;2.0;-7.0>;
	 s2 = theta[k+1];           /**     Varians          **/
	 
    dsum = sumsqrc(y - X*b0)/rows(y) ;    
    adFunc[1] = -0.5 * (log(M_2PI * s2) + dsum / s2);

return 1;             // 1 indicates success
}
// Her begynner koden

main()
{

/*
Frst m vi erklre hvilke navn som er variable. Det vil si at vi
vanligvis bygger opp denne variabellisten etterhvert som vi skriver programmet.
*/

decl n, k,i, theta, Kov, dfunc, q, theta0, b0, eps0, Kov0, dfunc0, lr, lr_pv, W, W_pv, LM, LM_pv;

/*
Vanligvis vil data eksistere :-), s derfor viser vi ogs
hvordan vi leser de inn fra en database:
*/
	
	decl data = new Database(), x1, x2, x3;
	data.Load("kap2_mkm.in7");
	data.Info();
	y = data.GetVar("y");
	x1 = data.GetVar("x1");
	x2 = data.GetVar("x2");
	x3 = data.GetVar("x3");
	X = x1~x2~x3;
	n = rows(y)	;
	k = columns(X);
	

/*
// Vi br ogs alltid se figurer av dataseriene.
// Vi lager derfor figurer som blir viste hvis vi bruker Oxmetrics:
	DrawT(0, y', 1, 1, 1);					  
	DrawTMatrix(1, X', {"x1", "x2", "x3"}, 1, 1, 1); 	  

	ShowDrawWindow();
*/
/*******************************************************************/

R =  <0,1,0;
		   0,0,1>;
	r = <2;-7>;


//Maksimerer likelihoodfunksjonen uten restriksjoner
theta = <1;1;1;1>;
floglik(theta, &dfunc, 0, 0);

print("Opprinnelig Likelihoodverdi er ", rows(y)*dfunc,
"ved verdiene: ", theta');

 MaxControl(-1,100);
 MaxBFGS(floglik, &theta, &dfunc, 0, TRUE);
Kov = (n/(n-k))*theta[k+1]*invert(X'X);
 print("Likelihoodverdien er ", rows(y)*dfunc,
"ved verdiene: ", theta');

print("standardavviket til beta^hatt er  ", sqrt(diagonal(Kov)));

print( "\n****************************************\n\n" );

//Med restriksjoner
theta0 = <1;1;1;1>;
floglik0(theta0, &dfunc0, 0, 0);

print("Opprinnelig likelihoodverdi med restriksjoner er ", rows(y)*dfunc0,
"ved verdiene: ", theta0');

 MaxControl(-1,100);
 MaxBFGS(floglik0, &theta0, &dfunc0, 0, TRUE);

b0 = theta[:k]+invert(X'X)*R'invert(R*invert(X'X)*R')*(r-R*theta[:k]);
Kov0 = (n/(n-k+q))*theta0[k+1]*(unit(k)-invert(X'X)*R'invert(R*invert(X'X)*R')*R)*invert(X'X);
 println("loglikelihoodverdien med restriksjoner er ", rows(y)*dfunc0,
"ved verdiene: ", b0');

println("sf(beta0hat):  ", sqrt(diagonal(Kov0)));
println("sigma0hat: ", 	sqrt((n/(n-k+q))*theta0[k+1]));
println( "\n****************************************\n\n" );
//LR-test
lr = -2*rows(y)*(dfunc0-dfunc) ;
lr_pv = 1-probchi(lr,1)	;

print("LR-test = ", lr);
print("p-verdi = ", lr_pv);
print( "\n****************************************\n\n" );
//Wald-test
W = ((R*theta[:k] - r)'*invert(R*invert(X'X)*R')*(R*theta[:k] -r))/theta[k+1];
W_pv = 1-probchi(W,1);
print("W-test = ", W);
print("p-verdi = ", W_pv);
print( "\n****************************************\n\n" );

//LM-test
eps0 = (y - X*b0);
LM = (eps0'*X*invert(X'X)*X'*eps0)/theta0[k+1];
LM_pv = 1-probchi(LM,1);
print("LM-test = ", LM);
print("p-verdi = ", LM_pv);

}	